import json import requests from datetime import datetime # ========================== # CONFIGURACIONES # ========================== CHANNELS = { "tnannastein": ["pickup", "delivery"], "magento": ["pickup", "delivery"], "MELI": ["pickup", "delivery"], "farmaciadigital": ["pickup", "delivery"], "farmatouch": ["pickup", "delivery"], "RAPPI": ["delivery"], "PEYA": ["delivery"], "benvida": ["pickup", "delivery"], "vtex": ["delivery"] } EXTERNAL_FILE = "external_number.txt" INITIAL_EXTERNAL = 40001400 URL = "https://bmc-foco.dev.napse.global:8444/order/create" SHIPPING_COST = 15 # costo fijo envío PROMO_DISCOUNT = 2400 # descuento fijo promo # ========================== # FUNCIONES # ========================== def get_next_external_number(): if os.path.exists(EXTERNAL_FILE): with open(EXTERNAL_FILE, "r") as f: num = int(f.read().strip()) else: num = INITIAL_EXTERNAL - 1 next_num = num + 1 with open(EXTERNAL_FILE, "w") as f: f.write(str(next_num)) return str(next_num) # ========================== # Variables # ========================== item1 = "1477" Descripcion1: "BRAVA DESOD. LUBRICANTE-sachet cajax20 cód.12060" item2 = "9018" Descripcion2 : "BETAVALMAX-60 mg gts.x 15 ml" store1 = "100000001" store2 = "100000002" store3 = "100000003" store4 = "100000004" # ========================== # INTERACCIÓN CON EL USUARIO # ========================== print("Seleccione un canal:") for i, (ch, modes) in enumerate(CHANNELS.items(), 1): marca = " *P/D" if len(modes) == 2 else "" print(f"{i}. {ch}{marca}") canal_idx = int(input("Número de canal: ").strip()) - 1 channelCode = list(CHANNELS.keys())[canal_idx] delivery_modes = CHANNELS[channelCode] # Selección de entrega if delivery_modes == ["delivery"]: deliveryOrPickup = "delivery" print(f"👉 Canal {channelCode} solo acepta delivery, se asigna automáticamente.") else: while True: print("\nTipo de entrega:") print("1. pickup") print("2. delivery") tipo_entrega_input = input("Seleccione 1 o 2: ").strip() if tipo_entrega_input == "1": deliveryOrPickup = "pickup" break elif tipo_entrega_input == "2": deliveryOrPickup = "delivery" break else: print("❌ Opción inválida. Debe elegir 1 o 2.") # ========================== # Selección de storeCode # ========================== print("\n3. Indicar Tienda") print("1. 100000001") print("2. 100000002") print("3. 100000003") print("4. 100000004") store_input = input("Seleccione 1 al 4: ").strip() if store_input == "1": storeCode = store1 elif store_input == "2": storeCode = store2 elif store_input == "3": storeCode = store3 elif store_input == "4": storeCode = store4 else: print("❌ Opción inválida. Debe elegir entre 1 y 4.") exit(1) # ¿Está pagado? isPaid = input("¿Está pagado? (s/n): ").strip().lower() == "s" # ¿Quiere aplicar descuento PROMO? aplicaPromo = input("¿Quiere aplicar descuento de PROMO? (s/n): ").strip().lower() == "s" ## Descuento manuales aplica_descuento_manual = input("¿Quiere aplicar un descuento manual sobre la transacción? (s/n): ").strip().lower() == "s" # ========================== # ARMADO DEL PEDIDO (Request) # ========================== creationDate = datetime.now().strftime("%Y-%m-%d") externalNumber = get_next_external_number() pedido = { "externalNumber": externalNumber, "creationDate": creationDate, "channelCode": channelCode, "currencyCode": "ARS", "manualDiscountAmount": 0, # permanece 0 para futuros usos "netAmount": 11000, # monto base "orderTypeCode": "web", "isPaid": isPaid, "party": { "code": "", "firstName": "Alejandro", "lastName": "Isola", "email": "Leo@napse.global", "typeCode": "Person", "identificationType": 1, "identifier": "2995028", "partyContactMethods": [ { "name": "personal", "address": { "firstLine": "Av San Aurelio 7844", "countryCode": "AR", "stateCode": "BA", "cityCode": "BSAS_194" }, "emailAddress": "alejandro.silva@napse.global", "telephone": { "telephoneNumber": "0342 4744900" }, } ] }, "detail": [ { "itemCode": item1, "description": Descripcion1, "storeCode": storeCode, "locationCode": "DEP1", "unitPrice": 5000, "orderedQty": 2, "deliveryOrPickup": deliveryOrPickup, "deliveryCompany": "100000003", "pickupLocationCode": "100000003", "packageId": "0", "partyContactMethodName": "personal", "pickupInformation": "Info: Alejandro Silva Mirgor retira por tienda." }, { "itemCode": item2, "description": Descripcion2, "storeCode": storeCode, "locationCode": "DEP1", "unitPrice": 1000, "orderedQty": 1, "deliveryOrPickup": deliveryOrPickup, "deliveryCompany": "100000003", "pickupLocationCode": "100000003", "packageId": "0", "partyContactMethodName": "personal", "pickupInformation": "Info: Alejandro Silva Mirgor retira por tienda." } ] } # Agregar envío si corresponde if deliveryOrPickup == "delivery": envio_item = { "itemCode": "ENVIO", "description": "Costo de Envio", "storeCode": storeCode , "locationCode": "DEP1", "unitPrice": SHIPPING_COST, "orderedQty": 1, "deliveryOrPickup": "delivery", "deliveryCompany": "magento", "pickupLocationCode": "100000003", "packageId": "0", "partyContactMethodName": "personal", "pickupInformation": "Info: Alejandro Silva retira por tienda.", "notes": "RECETA=true|CODIGO=999999|MATMED=88888888888888", "sellerID": "omni", "sellerName": "Usuario para WF OMNI" } pedido["detail"].append(envio_item) pedido["netAmount"] += SHIPPING_COST ##Descuento manuales if aplica_descuento_manual: try: descuento_manual = float(input("Ingrese el importe del descuento manual: ").strip()) if descuento_manual > 0 and descuento_manual <= pedido["netAmount"]: pedido["manualDiscountAmount"] = descuento_manual pedido["netAmount"] -= descuento_manual else: print("⚠️ Importe de descuento inválido. No se aplicará descuento manual.") except ValueError: print("⚠️ Valor ingresado no es numérico. No se aplicará descuento manual.") # Si aplica promo, agregar priceModifiers y ajustar netAmount if aplicaPromo: pedido["detail"][0]["priceModifiers"] = [ { "percent": 20, "amount": PROMO_DISCOUNT, "reasonText": "38" } ] pedido["netAmount"] -= PROMO_DISCOUNT # Payments if isPaid: pago = { "tender": "EL", "amount": pedido["netAmount"], # monto ajustado con promo/envío "currencyCode": "ARS", "planDescriptor": "12", "sellerName": "vISA CREDITO", "authorizationCode": "9187840193", "couponNumber": "123", "lotNumber": "4321", "installments": 6, "referenceNumber": "383409####0415" } pedido["payments"] = [pago] else: pedido["payments"] = [] # ========================== # MOSTRAR PEDIDO PARA REVISAR # ========================== print("\n📝 Pedido generado (vista previa):\n") print(json.dumps(pedido, indent=4, ensure_ascii=False)) print(f"\n💲 Monto final netAmount: {pedido['netAmount']}") # Confirmación antes de enviar confirm = input("\n¿Desea enviar este pedido? (s/n): ").strip().lower() if confirm not in ["s", "si"]: print("❌ Envío cancelado por el usuario.") exit(0) # ========================== # ENVÍO # ========================== # Token para envío token = input("\nIngrese el x-access-token: ").strip() headers = { "Content-Type": "application/json", "x-access-token": token } try: response = requests.post(URL, headers=headers, json=pedido) print(f"\n📡 Enviado a: {URL}") print("Status:", response.status_code) print("Respuesta:", response.text) except Exception as e: print("❌ Error al enviar:", str(e))